import React from "react";
import HeroSection from "../components/HeroSection";
import CategoryCard from "../categories/components/CategoryCard";
import SendQuestionButton from "./components/SendQuestionButton";
import axiosInstance from "@/api/axiosInstance";
import Link from "next/link";


export const metadata = {
  title: "الأسئلة الشرعية"
}
// Fetch categories from API
const fetchCategories = async () => {
  try {
    const res = await axiosInstance.get("/category-questions");
    return res.data;
  } catch (error) {
    console.error("فشل في تحميل بيانات التصنيفات:", error);
    return []; 
  }
};

const QuestionsPage = async () => {
  const categories = await fetchCategories();

  return (
    <div className="pt-20 font-amiri min-h-screen">
      {/* Hero Section */}
      <HeroSection
        title="الأسئلة الشرعية"
        length={categories.length}
        type="تصنيفات رئيسية"
        image="/download (2).png"
      />

      <SendQuestionButton />

      {/* Categories Grid */}
      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 justify-items-center gap-6 py-20 relative lg:px-12 md:px-8 px-5">
        {categories.map((category, index) => (
          <Link key={category.id} href={`/qa/${category.id}`}>
            <CategoryCard
              questionCategories={category.children_count}
              index={index}
              type="أقسام فرعية"
              name={category.name}
              
            />
          </Link>
        ))}
      </div>
    </div>
  );
};

export default QuestionsPage;
