import { MessageCircle, Send } from 'lucide-react'
import Link from 'next/link'
import React from 'react'

const SendQuestionButton = () => {
  return (
     <div className="flex justify-center mt-8 px-4">
       <Link href="/send-question" className="group bg-primary/90 text-tertiary px-8 py-4 rounded-2xl hover:shadow-xl transition-all duration-300 transform hover:scale-105 active:scale-95 flex items-center gap-3 shadow-lg cursor-pointer">
         <MessageCircle className="w-5 h-5 group-hover:scale-110 transition-transform duration-300" />
         <span className="text-lg font-medium">إرسال سؤال</span>
         <Send className="w-4 h-4 group-hover:translate-x-1 group-hover:-translate-y-1 transition-transform duration-300" />
       </Link>
     </div>
  )
}

export default SendQuestionButton