"use client"
import React, { useState, useEffect } from 'react'
import Link from 'next/link'
import axiosInstance from '@/api/axiosInstance'
import Loading from '@/app/components/Loading'
import LessonSlider from './components/LessonSlider'
import SendQuestionButton from './qa/components/SendQuestionButton'


const HomePage = () => {
  const [data, setData] = useState(null)
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    fetchHomeData()
  }, [])

  const fetchHomeData = async () => {
    try {
      const response = await axiosInstance.get('/home')
      setData(response.data)
    } catch (error) {
      console.error('Error fetching home data:', error)
    } finally {
      setLoading(false)
    }
  }

  if (loading) return <Loading />

  return (
    <div className='font-amiri'>


      
      {/* Hero Section with Islamic Background */}
<div 
  className="relative min-h-[70vh] bg-cover bg-center flex items-center justify-start pr-4 pt-16 px-10 md:px-20 overflow-hidden"
  style={{
    backgroundImage: "url('/81805.jpg')"
  }}
>
  <div className="absolute inset-0 bg-tertiary/60 to-transparent"></div>
  
  <div className="relative z-10 mt-10 text-quaternary w-full h-full flex flex-col items-start gap-7">
    <h1 className="text-4xl md:text-6xl font-bold leading-snug drop-shadow-lg font-amiri">
      موقع الشيخ محمد خير الشعّال
    </h1>
    
    <p className="text-lg md:text-xl text-quaternary/80 leading-relaxed max-w-2xl">
      اكتشف دروس ومحاضرات الشيخ محمد خير الشعّال، وتعلّم من علمه وخُطَبه،  
      كما يمكنك طرح أسئلتك الشرعية والحصول على إجابات موثوقة من مصادر معتمدة.
    </p>
    
    <Link 
      href="/categories"
      className="inline-block mt-7 bg-gradient-to-r from-primary to-secondary text-white px-10 py-3 rounded-full text-lg font-semibold shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300"
    >
         تصفح جميع التصنيفات
    </Link>
  </div>
</div>


      {/* Latest Lessons */}
      <LessonSlider lessons={data.latest_lessons}/>

      <div className='container mx-auto lg:px-8 md:px-6 px-4 py-12 max-w-6xl'>
        
        {/* Categories and Questions in Same Row */}
        <div className='grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12 mt-10'>
          
          {/* Questions Categories */}
          <section>
            <h2 className='text-2xl font-bold text-quaternary mb-6 text-right'>تصنيفات الأسئلة</h2>
            <div className='space-y-3'>
              {data.main_categories.map(category => (
                <Link key={category.id} href={`/qa/${category.id}`}>
                  <div className='bg-white border border-gray-200 rounded-lg p-4 hover:border-primary transition cursor-pointer'>
                    <div className='flex justify-between items-center'>
                      <h3 className='font-bold text-gray-800'>{category.name}</h3>
                      <span className='text-sm text-gray-600'>({category.questions_count})</span>
                    </div>
                  </div>
                </Link>
              ))}
            </div>
          </section>

          {/* Latest Questions */}
          <section>
            <h2 className='text-2xl font-bold text-quaternary mb-6 text-right'>أحدث الأسئلة</h2>
            <div className='space-y-3'>
              {data.latest_questions.map(question => (
                <Link key={question.id} href={`/question/${question.id}`}>
                  <div className='bg-white border border-gray-200 rounded-lg p-4 hover:border-primary transition cursor-pointer'>
                    <h3 className='font-bold text-gray-800 mb-1 line-clamp-2 text-right'>{question.title}</h3>
                    <p className='text-sm text-gray-600 text-right'>{question.category.name}</p>
                  </div>
                </Link>
              ))}
            </div>
          </section>

          <SendQuestionButton />

        </div>

      </div>
    </div>
  )
}

export default HomePage