"use client"
import React, { useEffect, useState } from 'react'
import Loading from '../components/Loading'
import ErrorComponent from '../components/ErrorComponent'
import axiosInstance from '@/api/axiosInstance'

const LiveStream = () => {
  const [liveStream, setLiveStream] = useState(null)  
  const [loading, setLoading] = useState(true)
  const [error, setError] = useState(null)

  useEffect(() => {
    fetchLiveStream()
  }, [])
  
  const fetchLiveStream = async () => {
    try {
      const res = await axiosInstance.get(`/live-stream`);
      setLiveStream(res.data.data)
    } catch (error) {
      setError('فشل في تحميل بيانات البث');
    }finally{
      setLoading(false)
    }
  };

  const getEmbedUrl = (url, platform) => {
    if (!url) return null;

    try {
      switch(platform) {
        case 'youtube':
          if (url.includes('youtube.com/channel/')) {
            const channelId = url.split('youtube.com/channel/')[1]?.split('/')[0];
            return `https://www.youtube.com/embed/live_stream?channel=${channelId}`;
          }
          if (url.includes('youtube.com/')) {
            const channelName = url.split('youtube.com/')[1]?.split('/')[0];
            return `https://www.youtube.com/embed/live_stream?channel=${channelName}`;
          }
          return url;

        case 'facebook':
          if (url.includes('facebook.com/') && (url.includes('/videos/') || url.includes('/video/'))) {
            return `https://www.facebook.com/plugins/video.php?href=${encodeURIComponent(url)}&show_text=false`;
          }
          return url;

        case 'mixlr':
          if (url.includes('mixlr.com/')) {
            const cleanUrl = url.replace(/^https?:\/\//, '');
            const parts = cleanUrl.split('mixlr.com/')[1]?.split('/');
            const username = parts?.[0];
            
            if (username && username !== 'users' && !url.includes('/embed')) {
              const embedUrl = `https://mixlr.com/users/${username}/embed`;
              return embedUrl;
            }
          }
          return url;

        default:
          return url;
      }
    } catch (error) {
      return url;
    }
  };

  if(loading) return <Loading />
  if(error) return <ErrorComponent error={error} onRetry={() => fetchLiveStream()}/>



  return (
    <div className="min-h-screen pt-8 font-amiri">
         {/* Header */}
        <div className=" relative w-full h-[220px] bg-center bg-cover font-amiri" 
                  style={{ backgroundImage: "url('/81805.jpg')" }}>
                  <div className="absolute inset-0 bg-tertiary/60 flex flex-col justify-center items-center gap-5 mt-14">      
                    <h1 className="text-4xl md:text-5xl font-extrabold text-quaternary text-center px-4">
                  البث المباشر
                    </h1>
                  </div>
                </div>
      <div className="max-w-6xl lg:px-12 md:px-8 px-5 my-10 mx-auto flex justify-center items-center min-h-[50vh]">
        <div className="w-full">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 justify-items-center">
            {/* YouTube Live */}
            {liveStream?.url_youtube && (
              <div className="bg-tertiary rounded-2xl shadow-lg border border-secondary/20 overflow-hidden hover:shadow-xl transition-all duration-300 w-full max-w-2xl">
                <h2 className="text-xl font-bold text-quaternary mb-4 text-center py-4 bg-tertiary border-b border-quaternary/20">يوتيوب</h2>
                <div className="aspect-video bg-black">
                  <iframe
                    src={getEmbedUrl(liveStream.url_youtube, 'youtube')}
                    className="w-full h-full"
                    allowFullScreen
                    title="YouTube Live Stream"
                  />
                </div>
              </div>
            )}

            {/* Facebook Live */}
            {liveStream?.url_facebook && (
              <div className="bg-tertiary rounded-2xl shadow-lg border border-secondary/20 overflow-hidden hover:shadow-xl transition-all duration-300 w-full max-w-2xl">
                <h2 className="text-xl font-bold text-quaternary mb-4 text-center py-4 bg-tertiary border-b border-quaternary/20">فيسبوك</h2>
                <div className="aspect-video bg-black">
                  <iframe
                    src={getEmbedUrl(liveStream.url_facebook, 'facebook')}
                    className="w-full h-full"
                    allowFullScreen
                    title="Facebook Live Stream"
                  />
                </div>
              </div>
            )}
          </div>

          {/* Mixlr */}
          {liveStream?.url_mixlr && (
            <div className="mt-8 bg-tertiary rounded-2xl shadow-lg border border-secondary/20 overflow-hidden hover:shadow-xl transition-all duration-300 w-full max-w-2xl mx-auto">
              <h2 className="text-xl font-bold text-quaternary mb-4 text-center py-4 bg-tertiary border-b border-quaternary/20">ميكسلر</h2>
              <div className="bg-black">
                <iframe
                  src={getEmbedUrl(liveStream.url_mixlr, 'mixer')}
                  className="w-full h-64"
                  title="Mixlr Live Stream"
                  allow="autoplay"
                />
              </div>
            </div>
          )}

          {/* Show message if no streams available */}
          {!liveStream?.url_youtube && !liveStream?.url_facebook && !liveStream?.url_mixer && (
            <div className="text-center py-20 flex justify-center items-center">
              <div className="bg-white rounded-2xl shadow-lg border border-secondary/20 p-12 max-w-md mx-auto">
                <p className="text-quaternary/70 text-xl font-medium">لا توجد بثوات مباشرة متاحة حالياً</p>
              </div>
            </div>
          )}

          {/* Status */}
          {liveStream?.is_active && (
            <div className="text-center mt-12 flex justify-center">
              <div className="inline-flex items-center gap-3 px-6 py-3 bg-primary/10 rounded-full border border-primary/20 backdrop-blur-sm">
                <div className={`w-3 h-3 rounded-full ${liveStream.is_active === 'active' ? 'bg-green-500 animate-pulse' : 'bg-gray-400'}`}></div>
                <span className="text-quaternary font-medium">
                  {liveStream.is_active === 'active' ? 'البث نشط الآن' : 'البث متوقف'}
                </span>
              </div>
            </div>
          )}
        </div>
      </div>
    </div>
  )
}

export default LiveStream