"use client";
import Slider from "react-slick";
import LessonCard from "../categories/components/LessonCard";

const LessonSlider = ({ lessons }) => {

  const settings = {
      dots: true,
        infinite: true,
        speed: 1000,
        slidesToShow: 4,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 3000,
        arrows: false,
    responsive: [
      { breakpoint: 1024, settings: { slidesToShow: 3 } },
      { breakpoint: 768, settings: { slidesToShow: 2, dots: false } },
      { breakpoint: 640, settings: { slidesToShow: 2, dots: false } },
      { breakpoint: 500, settings: { slidesToShow: 1, dots: true } },
    ],
  };


  return (
    <div className="mt-16 lg:px-12 md:px-8 px-5 w-full overflow-hidden">
      <h2 className="text-3xl font-bold text-quaternary text-right mb-8 font-amiri">
        أحدث الدروس
      </h2>
      <Slider {...settings}>
        {lessons.map((lesson) => (
          <div key={lesson.id} className="px-4">
            <LessonCard
              lesson={lesson}
              index={lesson.id}
              mainId={lesson.category.parent_id}
              subId={lesson.category.id}
            />
          </div>
        ))}
      </Slider>
    </div>
  );
};

export default LessonSlider;
