"use client"
import React, { useState } from 'react'
import { Search } from "lucide-react"
import { useRouter } from 'next/navigation'

const SearchBar = () => {
  const [query, setQuery] = useState('')
  const router = useRouter()

  const handleSearch = (e) => {
    e.preventDefault()
    
    if (query.trim()) {
      router.push(`/search?q=${encodeURIComponent(query.trim())}`)
    }
  }

  const handleKeyPress = (e) => {
    if (e.key === 'Enter') {
      handleSearch(e)
    }
  }

  return (
    <div className="flex items-stretch lg:w-fit w-full">
      <input 
        type="text" 
        placeholder="ابحث..." 
        value={query}
        onChange={(e) => setQuery(e.target.value)}
        onKeyPress={handleKeyPress}
        className="2xl:w-[400px] xl:w-[300px] lg:w-[210px] w-full md:px-3 px-2 py-[3px] md:py-1 border border-primary rounded-r-lg focus:outline-none focus:ring-2 focus:ring-secondary"
      />
      <button
        onClick={handleSearch}
        className="bg-primary text-white md:px-4 px-3 md:py-1 py-[3px] rounded-l-lg hover:bg-secondary transition flex justify-center items-center cursor-pointer"
      >
        <Search size={20} className="text-tertiary" />
      </button>
    </div>
  )
}

export default SearchBar