"use client"
import Logo from "./Logo";
import NavLinks from "./NavLinks";
import SearchBar from "./SearchBar";
import LiveButton from "./LiveButton";
import MobileMenu from "./MobileMenu";

const Header = () => {
  return (
    <header className="w-full font-amiri relative">
      <div className="bg-tertiary flex justify-between items-center shadow-2xl fixed top-0 left-0 right-0 z-50 py-5 lg:px-12 md:px-8 px-5">  
        {/* Logo */}
          <Logo />
        {/* Navigation */}
          <NavLinks />
        {/* Search and live button */}
        <div className="flex items-center 2xl:gap-8 xl:gap-6 lg:gap-5 lg:w-fit w-9/12">
          {/* Search */}
            <SearchBar />
          {/* live button */}
          <LiveButton />
        </div>

          <div className="block lg:hidden">
            <MobileMenu />
          </div>  
      </div>
    </header>
  );
};

export default Header;
