import React from 'react'

const ErrorComponent = ({error, onRetry, retryText="إعادة المحاولة"}) => {
  return (
    <div className="pt-20 font-amiri min-h-screen flex items-center justify-center bg-tertiary">
        <div className="text-center text-red-600">
          <p className="text-xl">⚠️ {error}</p>
          <button 
            onClick={() => onRetry}
            className="mt-4 px-6 py-2 bg-primary text-white rounded-lg hover:bg-green-700 transition cursor-pointer"
          >
             {retryText}
          </button>
        </div>
      </div>
  )
}

export default ErrorComponent