import React from 'react'
import Link from 'next/link'
const BreadCrumb = ({mainId, subId, parentCategory, category, title}) => {
  return (
     <nav className="mb-6">
          <ol className="flex items-center md:text-xl text-[16px] text-quaternary/85">
            <li className="flex items-center">
              <Link href={`/categories/${mainId}`} className="hover:text-primary transition">
                {parentCategory}
              </Link>
            </li>
            <li className="flex items-center">
              <span className="mx-2">/</span>
              <Link href={`/categories/${mainId}/${subId}`} className="hover:text-primary transition">
                {category}
              </Link>
            </li>
            <li className="flex items-center">
              <span className="mx-2">/</span>
              <span className="text-primary font-medium">{title}</span>
            </li>
          </ol>
        </nav>
  )
}

export default BreadCrumb