"use client";

import React from "react";
import Image from "next/image";
import { motion } from "framer-motion";

const AboutContent = () => {
  const fadeIn = {
    initial: { opacity: 0, y: 20 },
    animate: { opacity: 1, y: 0 },
    transition: { duration: 0.6 },
  };

  return (
    <div className="max-w-6xl mx-auto lg:px-12 md:px-8 px-5 my-10">
      <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-12">
        {/* Image Section */}
        <motion.div
          initial={{ opacity: 0, x: -30 }}
          animate={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8, delay: 0.2 }}
          className="lg:col-span-1"
        >
          <div className="bg-tertiary rounded-2xl shadow-lg p-6 sticky top-24">
            <div className="relative h-80 w-full mb-6">
              <Image
                src="/1649069428.jpg"
                alt="الشيخ الطبيب محمد خير الشَّعَّال"
                fill
                className="object-cover rounded-xl"
                priority
              />
            </div>
            <div className="text-center">
              <h3 className="text-2xl font-bold text-quaternary mb-2">
                محمد خير الشَّعَّال
              </h3>
              <p className="text-quaternary/90 mb-4">وُلد في دمشق - 1970م</p>
              <div className="bg-primary/10 rounded-lg p-4">
                <p className="text-quaternary font-medium">
                  متزوج وله ابن وثلاث بنات
                </p>
              </div>
            </div>
          </div>
        </motion.div>

        {/* Content Section */}
        <motion.div
          initial={{ opacity: 0, x: 30 }}
          animate={{ opacity: 1, x: 0 }}
          transition={{ duration: 0.8, delay: 0.4 }}
          className="lg:col-span-2"
        >
          <div className="space-y-8">

            {/* التعريف */}
            <motion.section {...fadeIn} className="bg-tertiary rounded-2xl shadow-lg p-6">
              <h2 className="text-2xl font-bold text-quaternary mb-4 border-b border-secondary/30 pb-2">
                التعريف
              </h2>
              <p className="text-quaternary/90 leading-relaxed text-lg">
                محمد خير بن محيي الدين الشَّعَّال، وُلد في مدينة دمشق بسوريا، حي الصَّالحية، عام 1970م. متزوج وله ابن وثلاث بنات.
              </p>
            </motion.section>

            {/* الشهادات العلمية */}
            <motion.section {...fadeIn} className="bg-tertiary rounded-2xl shadow-lg p-6">
              <h2 className="text-2xl font-bold text-quaternary mb-4 border-b border-secondary/30 pb-2">
                الشهادات العلمية
              </h2>
              <ul className="space-y-3 text-quaternary/90">
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>الثانوية العلمية، الثانوية الشرعية، والثانوية الأدبية.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>تخرج في كلية طب الأسنان عام 1992م، وكان من العشرة الأوائل على دفعته.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>درس في كلية أصول الدين جامعة أم درمان الإسلامية وتخرج عام 1998م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>دبلوم الدراسات العليا في علم الحديث والسنَّة عام 1999م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>الماجستير في السنَّة وعلوم الحديث عام 2002م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>الدكتوراه في دراسة إسنادية لروايات أسباب النزول في سورة البقرة عام 2009م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>إجازات متعددة في علم الحديث من أساتذته.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>درس علوم الدعوة والتربية على يد الشيخ أحمد كفتارو.</li>
              </ul>
            </motion.section>

            {/* الخبرات العملية */}
            <motion.section {...fadeIn} className="bg-tertiary rounded-2xl shadow-lg p-6">
              <h2 className="text-2xl font-bold text-quaternary mb-4 border-b border-secondary/30 pb-2">
                الخبرات العملية
              </h2>
              <ul className="space-y-3 text-quaternary/90">
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>مدرِّس في كلية الدعوة الإسلامية وكلية أصول الدين منذ 2000م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>خطيب في مساجد دمشق وريفها منذ عام 1990م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>مدرِّس ديني لدى وزارة الأوقاف.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>مدير في وزارة الأوقاف 2010م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>شارك في إعداد الاستراتيجيات الوطنية لمكافحة العنف والإيدز.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>أشرف على دورات تأهيلية للحياة الزوجية منذ عام 2007م.</li>
                <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>عضو مؤسس في جمعية البركة للتنمية الاجتماعية.</li>
              </ul>
            </motion.section>

            {/* المؤلفات */}
            <motion.section {...fadeIn} className="bg-tertiary rounded-2xl shadow-lg p-6">
              <h2 className="text-2xl font-bold text-quaternary mb-4 border-b border-secondary/30 pb-2">
                من مؤلَّفاته
              </h2>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4 text-quaternary/90">
                <ul className="space-y-2">
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>سلسلة الطب والإيمان</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>سلسلة الحديث الميسّر</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>سلسلة على منابر دمشق</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>سلسلة أسرتي</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>نداء إلى الإسلاميين فلنتعلم الحكمة</li>
                </ul>
                <ul className="space-y-2">
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>التوجيهات النبوية للتعامل مع القرآن الكريم</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>لمحات في أعلام المحدثين</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>قرن جديد ورجال جدد</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>الأسرة والتربية</li>
                  <li className="flex items-start"><span className="text-primary mr-2 mt-1">•</span>قضايا الشباب</li>
                </ul>
              </div>
            </motion.section>

          </div>
        </motion.div>
      </div>
    </div>
  );
};

export default AboutContent;

