import HeroSection from "../components/HeroSection";
import CategoryCard from "./components/CategoryCard";
import Link from "next/link";
import axiosInstance from "@/api/axiosInstance";

export const metadata = {
  title: "التصنيفات"
}
export default async function CategoriesPage() {
  const res = await axiosInstance.get("/categories");
  const categories = res.data.data;

  return (
    <div className="pt-20 font-amiri">
      <HeroSection
        title="التصنيفات"
        length={categories.length}
        type="تصنيفات متاحة"
        image="/download (1).png"
      />

      <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 justify-items-center gap-6 py-20 relative lg:px-12 md:px-8 px-5">
        {categories.map((category, index) => (
          <Link key={category.id} href={`/categories/${category.id}`}>
            <CategoryCard
              subCategories={category.children_count}
              index={index}
              type="موضوع"
              name={category.name}
            />
          </Link>
        ))}
      </div>
    </div>
  );
}
