"use client"
import React from 'react';
import { motion } from "framer-motion";

const CategoryCard = ({name, subCategories = null, lessons = null, questionCategories = null, index, type }) => {
  return (
    <motion.div
      initial={{ opacity: 0, y: 30 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{
        duration: 0.3,
        delay: index * 0.2,
      }}
      whileHover={{ 
        y: -5,
        transition: { duration: 0.2 }
      }}
      whileTap={{ y: -3 }} 
      className="relative w-56 h-48 rounded-xl flex flex-col justify-between p-6 bg-tertiary cursor-pointer group border border-gray-100 hover:border-primary/20 active:border-primary/20 shadow-sm hover:shadow-md active:shadow-md transition-all duration-300 my-1"
    >
      {/* Minimal header section */}
      <div className="flex flex-col items-start">
        {/* Simple decorative line */}
        <div className="w-12 h-1 bg-primary rounded-full mb-4 group-hover:w-16 group-active:w-16 transition-all duration-300"></div>
        
        {/* Category name with elegant typography */}
        <h1 className="text-quaternary text-2xl font-medium text-left leading-tight">
          {name}
        </h1>
      </div>

      {/* Bottom section with topics count */}
      <div className="flex justify-between items-end">
          <span className="text-primary text-sm font-medium px-3 py-1 rounded-full bg-secondary/30">
            {subCategories || lessons  || questionCategories} {type}
          </span>
        {/* Simple arrow indicator - mobile friendly */}
        <div className="text-primary opacity-0 group-hover:opacity-100 group-active:opacity-100 transform translate-x-0 group-hover:translate-x-1 group-active:translate-x-1 transition-all duration-300">
          →
        </div>
      </div>

      {/* Very subtle hover background */}
      <div className="absolute inset-0 bg-gradient-to-br from-primary/0 to-primary/0 rounded-xl group-hover:from-primary/2 group-hover:to-primary/5 group-active:from-primary/2 group-active:to-primary/5 transition-all duration-500 z-0"></div>
    </motion.div>
  );
};

export default CategoryCard;